<?php

namespace App\Http\Repositories\Admin;

use App\Models\Package;
use App\Models\Subscribe;
use App\Http\Interfaces\Admin\SubscribeInterface;
use Illuminate\Database\Eloquent\Collection;

class SubscribeRepository implements SubscribeInterface
{
    protected $subscribeModel;
    protected $packageModel;

    public function __construct(
        Subscribe $subscribe,
        Package $package,
    ) {
        $this->subscribeModel = $subscribe;
        $this->packageModel = $package;
    }

    public function index(): Collection
    {
        return $this->subscribeModel::with(['user', 'package'])->get();
    }

    public function delete(Subscribe $subscribe): void
    {
        $subscribe->delete();
    }
}
