<?php

namespace App\Http\Repositories\Admin;

use App\Models\Page;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\PageInterface;

class SubPageRepository implements PageInterface{

    protected $pageModel;

    public function __construct(Page $page){
        $this->pageModel =$page;
    }
    public function index(){
        $pages=  $this->pageModel::where('subpage', '1')->get();
        return view('Admin.subpage.index',compact('pages'));
    }
    public function create(){
        return view('Admin.subpage.create');
    }

    public function store($request)
    {
        $request->validate([
            'title' => 'required|unique:pages,title'
        ]);

        $page =  $this->pageModel::create([
            'title'             =>  $request->title,
            'description'       =>   $request->description
        ]);

        Alert::success('success', ' Page Added Successfully');
        return redirect()->route('admin.subpage.index');
    }

    public function edit($id){
        $page=$this->pageModel::find($id);
        return view('Admin.subpage.edit',compact('page'));
    }

    public function update($request)
    {
        $page =  $this->pageModel::find($request->id);
        if ($request->title != $page->title) {
            $request->validate([
                'title' => 'required|unique:pages,title'
            ]);
        }

        $page->update([
            'title'             =>  $request->title,
            'description'       =>   $request->description
        ]);
        Alert::success('success', ' Page  updated Successfully');
        return redirect()->route('admin.subpage.index');
    }

    public function  destroy($id){
        $page=$this->pageModel::find($id);

        if($page){
            $page->delete();
            return  1;
        }

       return 0 ;

    }





}
