<?php
namespace App\Http\Repositories\Admin;

use App\Models\Page;
use App\Models\Slider;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\SliderInterface;

class SliderRepository implements SliderInterface{
    use ImageTrait;
  protected $sliderModel;
  protected $pageModel;
  public function __construct(Slider $slider ,Page $page)
  {
   
      $this->sliderModel=$slider;
      $this->pageModel =$page;
  }
    public function index(){
        $sliders= $this->sliderModel::get();
        return view('Admin.slider.index',compact('sliders'));
    }

    public function create(){
        $pages =  $this->pageModel::get();
       return view('Admin.slider.create',compact('pages'));
   
   }


    public function store($request){

        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'slider');
            $image= 'images/slider/'.$images;
     
        }
        $slider =  $this->sliderModel::create([
            'page_id'           =>  $request->page_id,
            'image'             =>   $image,
            'title'             =>  $request->title,
            'description'       =>  $request->description,
            'status'            =>  0
        ]);
        Alert::success('success', ' Slider Added Successfully');
        return redirect()->route('admin.slider.index');
    }

    public function edit($id){
        $slider=$this->sliderModel::find($id);
        $pages =$this->pageModel::get();
        return view('Admin.slider.edit',compact('slider','pages'));
    }

    public function update($request){

        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'slider');
            $image= 'images/slider/'.$images;
     
        }
        $slider =  $this->sliderModel::find($request->id);
        $slider->update([
            'page_id'           =>   $request->page_id,
            'image'             =>   $image ?? $slider->image,
            'title'             =>  $request->title,
            'description'       =>  $request->description
           
        ]);
        Alert::success('success', ' Slider updated Successfully');
        return redirect()->route('admin.slider.index');

    }

    public function  destroy($id){
        $slider=$this->sliderModel::find($id);
    
        if($slider){
            $slider->delete();
            return  1;
        }
        return  0;
    }


    
}