<?php

namespace App\Http\Repositories\Admin;

use App\Models\Seller;
use App\Http\Interfaces\Admin\SellerInterface;


class SellerRepository implements SellerInterface
{
    public function store($data): Seller
    {
        return Seller::create($data);
    }

    public function update($data, Seller $seller): Seller
    {
        $seller->update($data);
        return $seller;
    }

    public function  destroy(Seller $seller): void
    {
        $seller->delete();
        return;
    }
}
