<?php

namespace App\Http\Repositories\Admin;

use App\Models\Role;
use App\Models\Permission;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\RoleInterface;


class RoleRepository  implements RoleInterface
{
    public function index()
    {

        $user = Auth::user();
        if ($user->hasRole('Admin')) {
            $roles = Role::get();
            $permissions = Permission::get();
            return view('Admin.roles.index', compact('roles', 'permissions'));
        } else {
            return redirect()->back()->with('error', 'you dont have permissions to this actions');
        }
    }

    public function create()
    {
        return view('Admin.roles.create');
    }
    public function store($request)
    {
        $request->validate([
            'name' => 'required|unique:roles,name',
        ]);

        $user = Auth::user();
        if ($user->hasRole('Admin')) {
            $role =   Role::create([
                'name' => $request->name,
                'display_name' => $request->name,
                'description' => $request->description,

            ]);

            Alert::success('success', ' Roles Added Successfully');
            return redirect()->route('admin.role.index');
        } else {
            Alert::success('success', 'you dont have roles to this actions');
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $role = Role::find($id);
        return view('Admin.roles.edit', compact('role'));
    }

    public function update($request)
    {

        $role = Role::find($request->id);
        if ($role->name != $request->name) {
            $request->validate([
                'name' => 'required|unique:roles,name',
            ]);
        }
        $role->update([

            'name' => $request->name,
            'display_name' => $request->name,
            'description' => $request->description,

        ]);


        Alert::success('success', ' ٍrole  updated Successfully');
        return redirect()->route('admin.role.index');
    }

    public function  destroy($id)
    {
        $role = Role::find($id);

        if ($role) {
            $role->delete();
            return  1;
        }
        return  0;
    }

    public function addRole($request)
    {

        $user = Auth::user();
        if ($user->hasRole('Admin')) {
            $role =   Role::create([
                'name' => $request->name,
                'display_name' => $request->name,
                'description' => $request->description,

            ]);
            return  redirect()->back()->with('success', 'you added permission successfully');
        } else {
            return redirect()->back()->with('error', 'you dont have permissions to this actions');
        }
    }

    public function addPermissionPage($id)
    {
        $role = Role::find($id);
        $permissions = Permission::get();
        return view('Admin.roles.addpermission', compact('role', 'permissions'));
    }

    public function addPermission($request)
    {
        $user = Auth::user();
        if ($user->hasRole('Admin') && $request->permissions) {
            $role = Role::find($request->id);
            $role->syncPermissions($request->permissions);
            Alert::success('success', 'permission Added Successfully');
            return redirect()->route('admin.role.index');
        } else {
            return redirect()->back()->with('error', 'you dont have permissions to this actions');
        }
    }
}
