<?php

namespace App\Http\Repositories\Admin;

use App\Models\Review;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\ReviewInterface;


class ReviewRepository implements ReviewInterface{
    use ImageTrait;
    protected $reviwModel;

    public function __construct(Review  $review){
        $this->reviwModel =$review;
    }

    public function index(){
        $reviews= $this->reviwModel::get();
        return view('Admin.review.index',compact('reviews'));
    }

    public function create(){
        return view('Admin.review.create');
    }
    public function store($request){
        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'review');
            $image= 'images/review/'.$images;
     
        }
        $review= $this->reviwModel::create([
            'rate'     =>$request->rate,
            'image'    =>$image,
            'comment'  =>$request->comment,
            'name'     =>$request->name
        ]);

        Alert::success('success', 'Review Added Successfully');
        return redirect()->route('admin.review.index');
    }

    public function edit($id){
        $review= $this->reviwModel::find($id);
        
        return view('Admin.review.edit',compact('review'));
    }
   

    public function update($request){
        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'review');
            $image= 'images/review/'.$images;
     
        }
        $review= $this->reviwModel::find($request->id);
        $review->update([

            'rate'     =>$request->rate,
            'comment'  =>$request->comment,
            'image'    =>$image ?? $review->image,
            'name'     =>$request->name
        ]);
        Alert::success('success','Review Update Successfully');
        return redirect()->route('admin.review.index');
    }

    public function destroy($id){
        $review= $this->reviwModel::find($id);
        if($review){
            $review->delete();
            return  1;
        }
       return 0 ;


    }
    
}

