<?php

namespace App\Http\Repositories\Admin;

use App\Models\RegisterVideo;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\RegisterVideoInterface;


class RegisterVideoRepository implements RegisterVideoInterface
{
    use ImageTrait;
    protected $registervideoModel;

    public function __construct(RegisterVideo $registervideo)
    {
        $this->registervideoModel = $registervideo;
    }

    public function index()
    {

        $registervideos = $this->registervideoModel::get();
        return view('Admin.registervideo.index', compact('registervideos'));
    }


    public function create()
    {
        return view('Admin.registervideo.create');
    }

    public function store($request)
    {
        if ($request->hasFile('video')) {
            $filename = time() . '.' . $request->video->extension();
            $videos =  $this->uploadImage($request->video, $filename, 'registervideo');
            $video = 'images/registervideo/' . $videos;
        }
        $registervideo = $this->registervideoModel::create([
            'video' => $video,
            'title' => $request->title
        ]);

        Alert::success('success', ' RegisterVideo Added Successfully');
        return redirect()->route('admin.registervideo.index');
    }

    public function edit($id)
    {
        $registervideo = $this->registervideoModel::find($id);

        return view('Admin.registervideo.edit', compact('registervideo'));
    }

    public function update($request)
    {
        if ($request->hasFile('video')) {
            $filename = time() . '.' . $request->video->extension();
            $videos =  $this->uploadImage($request->video, $filename, 'registervideo');
            $video = 'images/registervideo/' . $videos;
        }
        $registervideo = $this->registervideoModel::find($request->id);

        $registervideo->update([
            'video' =>  $video ?? $registervideo->video,
            'title' => $request->title
        ]);

        Alert::success('success', ' RegisterVideo updated Successfully');
        return redirect()->route('admin.registervideo.index');
    }

    public function destroy($id)
    {
        $registervideo = $this->registervideoModel::find($id);

        if ($registervideo) {
            $registervideo->delete();
            return  1;
        }

        return 0;
    }
}
