<?php

namespace App\Http\Repositories\Admin;

use App\Models\Page;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\PageInterface;
use Illuminate\Support\Facades\Route;

class PageRepository implements PageInterface{

    protected $pageModel;

    public function __construct(Page $page){
        $this->pageModel =$page;
    }
    public function index()
    {
        if (Route::is('admin.sub.page*')) {
            $pages=  $this->pageModel::where('subpage', '1')->get();
            return view('Admin.subpage.index',compact('pages'));
        }

        $pages=  $this->pageModel::where('subpage', '0')->get();
        return view('Admin.page.index',compact('pages'));
    }
    public function create(){
        if (Route::is('admin.sub.page*')) {
            return view('Admin.subpage.create');
        }
        return view('Admin.page.create');
    }

    public function store($request)
    {
        $request->validate([
            'title' => 'required|unique:pages,title'
        ]);

        $page =  $this->pageModel::create([
            'title'             =>  $request->title,
            'description'       =>  $request->description,
            'subpage'           =>  Route::is('admin.sub.page*') ? '1' : '0'
        ]);

        Alert::success('success', ' Page Added Successfully');
        if (Route::is('admin.sub.page*')) {
            return redirect()->route('admin.sub.page.index');
        }
        return redirect()->route('admin.page.index');
    }

    public function edit($id)
    {
        if (Route::is('admin.sub.page*')) {
            $page=$this->pageModel::find($id);
            return view('Admin.subpage.edit',compact('page'));
        }

        $page=$this->pageModel::find($id);
        return view('Admin.page.edit',compact('page'));
    }

    public function update($request)
    {
        $page =  $this->pageModel::find($request->id);
        if ($request->title != $page->title) {
            $request->validate([
                'title' => 'required|unique:pages,title'
            ]);
        }

        $page->update([
            'title'             =>  $request->title,
            'description'       =>   $request->description,
            'subpage'           =>  Route::is('admin.sub.page*') ? '1' : '0'
        ]);

        Alert::success('success', ' Page  updated Successfully');
        if (Route::is('admin.sub.page*')) {
            return redirect()->route('admin.sub.page.index');
        }
        return redirect()->route('admin.page.index');
    }

    public function  destroy($id)
    {
        $page=$this->pageModel::find($id);

        if($page){
            $page->delete();
            return  1;
        }

       return 0 ;

    }





}
