<?php 

namespace App\Http\Repositories\Admin;

use App\Models\User;
use App\Models\Admin;
use App\Models\Message;
use App\Http\Interfaces\Admin\MessagesInterface;

class MessagesRepository  implements MessagesInterface{

    protected $messageModel;
    protected $userModel;
    public function __construct(Message $message,User $user)
    {
        $this->messageModel=$message;
        $this->userModel =$user;
    }

    public function index($id){
        
        $messages= $this->messageModel::where('sender_id', $id)->orWhere('reciver_id',$id)->get();
        $user = $this->userModel::find($id);
        foreach($messages->where('sender_id', $id) as $message){
          $message->update([
            'read_at' => date('Y-m-d H:i:s'),
        ]);  
        }
        

        
        return view('Admin.student.messages',compact('messages','user'));
    }

    public function answer($request){

        $user= User::find($request->user_id);
        $admin= Admin::find(auth()->guard('admin')->user()->id);
  $message= $user->recievedMessages()->create([
'message_text' =>$request->message,
'sender_id'   =>$admin->id,
'sender_type'=>get_class($admin)
   ]);
   
   return response()->json([
      'bool'=>true,
      'message'=>$request->message,
      'time' => $message->created_at->format('H:i'),
      'name' => $admin->name
      
  ]);
        
    }
}