<?php

namespace App\Http\Repositories\Admin;

use Embed\Embed;
use App\Models\Unit;
use App\Models\Lesson;
use App\Http\Traits\ImageTrait;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\LessonInterface;

class LessonRepository implements LessonInterface
{
    use ImageTrait;
    protected $lessonModel;
    protected $unitModel;
    public function __construct(Lesson $lesson, Unit $unit)
    {
        $this->lessonModel = $lesson;
        $this->unitModel = $unit;
    }
    public function index()
    {
        $lessons = $this->lessonModel::with('unit', 'audios', 'videos')->get();

        return view('Admin.lesson.index', compact('lessons'));
    }

    public function create()
    {
        $units = $this->unitModel::get();
        return view('Admin.lesson.create', compact('units'));
    }

    public function store($request)
    {
        DB::transaction(function () use ($request) {
            if ($request->hasFile('notes')) {
                $filename = time() . '.' . $request->notes->extension();
                $notes = $this->uploadImage($request->notes, $filename, 'notes');
                $note = 'images/notes/' . $notes;
            }

            if ($request->link) {
                $embed = new Embed();

                //Load any url:
                $info = $embed->get($request->link);
            }


            $maxNumberLesson = $this->lessonModel::whereUnitId($request->unit_id)->max('number');
            $lesson = $this->lessonModel::create([
                'unit_id' => $request->unit_id,
                'number' => $maxNumberLesson + 1,
                'title' => $request->title,
                'description' => $request->description,
                'link' => $info->code->html ?? '',
                'notes' => $note ?? "",
            ]);

            if ($request->hasFile('audio')) {
                $filename = time() . '.' . $request->audio->extension();
                $audios = $this->uploadImage($request->audio, $filename, 'lessonaudio');
                $audio = 'images/lessonaudio/' . $audios;
                $lesson->audios()->create([
                    'audio' => $audio,
                    'type' => 'audio',
                ]);
            }
            // if ($request->hasFile('video')) {
            //     $filename = time() . '.' . $request->video->extension();
            //     $videos = $this->uploadImage($request->video, $filename, 'lessonvideo');
            //     $video = 'images/lessonvideo/' . $videos;
            //     $lesson->videos()->create([
            //         'video' => $video,
            //         'type' => 'video',
            //     ]);
            // }

            // if (!is_null($request->audio)) {
            //     $lesson->audios()->create([
            //         'audio' => $request->audio,
            //         'type' => 'audio',
            //     ]);
            // }

            if (!is_null($request->video)) {
                $lesson->videos()->create([
                    'video' => $request->video,
                    'type' => 'video',
                ]);
            }

            if ($request->hasFile('image')) {
                $filename = time() . '.' . $request->image->extension();
                $images = $this->uploadImage($request->image, $filename, 'lessonimage');
                $image = 'images/lessonimage/' . $images;
                $lesson->images()->create([
                    'image' => $image,
                    'type' => 'image',
                ]);
            }
        });
        Alert::success('success', ' Lesson Added Successfully');
        return redirect()->route('admin.lesson.index');
    }

    public function edit($id)
    {
        $lesson = $this->lessonModel::find($id);
        $units = $this->unitModel::get();
        return view('Admin.lesson.edit', compact('lesson', 'units'));
    }

    public function update($request)
    {
        DB::transaction(function () use ($request) {
            if ($request->hasFile('notes')) {
                $filename = time() . '.' . $request->notes->extension();
                $notes = $this->uploadImage($request->notes, $filename, 'notes');
                $note = 'images/notes/' . $notes;
            }
            if ($request->link) {
                $embed = new Embed();

                //Load any url:
                $info = $embed->get($request->link);
            }

            $lesson = $this->lessonModel::find($request->id);

            if ($lesson->unit_id !== $request->unit_id) {
                $number = $this->lessonModel::whereUnitId($request->unit_id)->max('number') + 1;
            } else {
                $number = $lesson->number;
            }

            $lesson->update([
                'unit_id' => $request->unit_id,
                'number' => $number,
                'title' => $request->title,
                'description' => $request->description,
                'link' => $info->code->html ?? '',
                'notes' => $note ?? $lesson->notes,
            ]);

            // if (!is_null($request->audio)) {
            //     $lesson->audios()->updateOrCreate([
            //         'audio' => $request->audio,
            //         'type' => 'audio',
            //     ]);
            // }

            if (!is_null($request->video)) {
                $lesson->videos()->updateOrCreate([
                    'video' => $request->video,
                    'type' => 'video',
                ]);
            }

            if ($request->hasFile('audio')) {
                $lesson->audios()->delete();
                $filename = time() . '.' . $request->audio->extension();
                $audios = $this->uploadImage($request->audio, $filename, 'lessonaudio');
                $audio = 'images/lessonaudio/' . $audios;
                $lesson->audios()->create([
                    'audio' => $audio,
                    'type' => 'audio',
                ]);
            }
            // if ($request->hasFile('video')) {
            //     $lesson->videos()->delete();
            //     $filename = time() . '.' . $request->video->extension();
            //     $videos = $this->uploadImage($request->video, $filename, 'lessonvideo');
            //     $video = 'images/lessonvideo/' . $videos;
            //     $lesson->videos()->create([
            //         'video' => $video,
            //         'type' => 'video',
            //     ]);
            // }
        });
        Alert::success('success', ' Lesson  updated Successfully');
        return redirect()->route('admin.lesson.index');
    }

    public function destroy($id)
    {
        $lesson = $this->lessonModel::find($id);

        if ($lesson) {
            $lesson->delete();
            return 1;
        }
        return 0;
    }
}
