<?php 
namespace App\Http\Repositories\Admin;



use App\Models\Lesson;
use App\Models\LessonFaq;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\LessonFaqInterface;
use Illuminate\Support\Facades\Auth;

class LessonFaqRepository implements LessonFaqInterface{

protected $lessonFaqModel;
protected $lessonModel;
public function __construct(LessonFaq $lessonFaq ,Lesson $lesson)
{
 
    $this->lessonFaqModel=$lessonFaq;
    $this->lessonModel=$lesson;
}
public function index(){
    $lessonfaqs=  $this->lessonFaqModel::with('lesson')->get();

    return view('Admin.lessonfaq.index',compact('lessonfaqs'));
}



public function edit($id){
    $lessonfaq=$this->lessonFaqModel::find($id);
    $lessons =  $this->lessonModel::get();
    return view('Admin.lessonfaq.edit',compact('lessonfaq','lessons'));

}


public function update($request){
   
    $lessonfaq=$this->lessonFaqModel::find($request->id);
    $lessonfaq->update([

        'answer'=>$request->answer,
        'answerd_by'=> Auth::guard('admin')->user()->name,
        'status'  => 1
        
          
      ]);
    Alert::success('success', ' LessonFaq  updated Successfully');
    return redirect()->route('admin.lessonfaq.index');
}

public function  destroy($id){
    $lessonFaq=$this->lessonFaqModel::find($id);

    if($lessonFaq){
        $lessonFaq->delete();
        return  1;
    }
    return  0;
}



}