<?php

namespace App\Http\Repositories\Admin;

use App\Http\Traits\ImageTrait;
use App\Models\GuideSubCategory;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\GuidesSubCategoryInterface;
use App\Models\GuideCategory;

class GuidesSubCategoryRepository implements GuidesSubCategoryInterface
{



    protected $guidesSubCategoryModel;
    protected $guideCategory;

    public function __construct(GuideSubCategory $guidesSubCategory, GuideCategory $guideCategory)
    {
        $this->guidesSubCategoryModel = $guidesSubCategory;
        $this->guideCategory = $guideCategory;
    }
    public function index()
    {
        $guidesubcategories =  $this->guidesSubCategoryModel::with('guideCategory')->get();
        return view('Admin.guidesubcategory.index', compact('guidesubcategories'));
    }
    public function create()
    {
        $guidecategories = $this->guideCategory::get();
        return view('Admin.guidesubcategory.create', compact('guidecategories'));
    }

    public function store($request)
    {

        $guidesSubCategory =  $this->guidesSubCategoryModel::create([
            'title'             =>  $request->title,
            'guide_category_id'       =>  $request->guide_category_id
        ]);
        Alert::success('success', ' guidesSubCategory Added Successfully');
        return redirect()->route('admin.guidesubcategory.index');
    }

    public function edit($id)
    {
        $guidesubcategory = $this->guidesSubCategoryModel::find($id);
        $guidecategories = $this->guideCategory::get();
        return view('Admin.guidesubcategory.edit', compact('guidesubcategory', 'guidecategories'));
    }

    public function update($request)
    {


        $guidesubcategory =  $this->guidesSubCategoryModel::find($request->id);
        $guidesubcategory->update([
            'title'             =>  $request->title,
            'guide_category_id'       =>  $request->guide_category_id,
        ]);
        Alert::success('success', ' guide Category  updated Successfully');
        return redirect()->route('admin.guidesubcategory.index');
    }

    public function  destroy($id)
    {
        $guidesSubCategory = $this->guidesSubCategoryModel::find($id);

        if ($guidesSubCategory) {
            $guidesSubCategory->delete();
            return  1;
        }

        return 0;
    }
}
