<?php

namespace App\Http\Repositories\Admin;

use App\Models\Guide;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\GuideInterface;
use App\Models\GuideSubCategory;

class GuideRepository implements GuideInterface
{
    protected $guidesModel;
    protected $guideSubCategoryModel;

    public function __construct(Guide $guides,GuideSubCategory $guideSubCategory){
        $this->guidesModel =$guides;
        $this->guideSubCategoryModel= $guideSubCategory;
    }
    public function index(){
        $guides=  $this->guidesModel::get();
        return view('Admin.guide.index',compact('guides'));
    }
    public function create(){
        $guidesubcategories =$this->guideSubCategoryModel::get();
        return view('Admin.guide.create',compact('guidesubcategories'));
    }

    public function store($request)
    {
        $request->validate([
            'title'                 => 'required',
            'created_by'            => 'required',
            'written_at'            => 'required',
            'guide_sub_category_id' => 'required',
            'description'           => 'required'
        ]);

        $guides =  $this->guidesModel::create([
            'title'                       =>  $request->title,
            'created_by'                  =>  $request->created_by,
            'written_at'                  =>  $request->written_at,
            'guide_sub_category_id'       =>  $request->guide_sub_category_id,
            'description'                 =>  $request->description
        ]);

        Alert::success('success', ' guides Added Successfully');
        return redirect()->route('admin.guide.index');
    }

    public function edit($id){
        $guide=$this->guidesModel::find($id);
        $guidesubcategories =$this->guideSubCategoryModel::get();
        return view('Admin.guide.edit',compact('guide','guidesubcategories'));

    }

    public function update($request)
    {
        $request->validate([
            'title'                 => 'required',
            'created_by'            => 'required',
            'written_at'            => 'required',
            'guide_sub_category_id' => 'required',
            'description'           => 'required'
        ]);

        $guide =  $this->guidesModel::find($request->id);
        $guide->update([
            'title'                       =>  $request->title,
            'created_by'                  =>  $request->created_by,
            'written_at'                  =>  $request->written_at,
            'guide_sub_category_id'       =>  $request->guide_sub_category_id,
            'description'                 =>  $request->description
        ]);
        Alert::success('success', ' guide   updated Successfully');
        return redirect()->route('admin.guide.index');
    }

    public function  destroy($id){
        $guides=$this->guidesModel::find($id);

        if($guides){
            $guides->delete();
            return  1;
        }

       return 0 ;

    }





}
