<?php 
namespace App\Http\Repositories\Admin;



use App\Models\Lesson;
use App\Models\FlashCard;
use App\Http\Traits\ImageTrait;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\FlashCardInterface;



class FlashCardRepository implements FlashCardInterface{
use ImageTrait;
protected $flashCardModel;
protected $lessonModel;
public function __construct(FlashCard $flashCard ,Lesson $lesson)
{
 
    $this->flashCardModel=$flashCard;
    $this->lessonModel=$lesson;
}
public function index(){
    $flashcards=  $this->flashCardModel::with('lesson','audios')->get();

    return view('Admin.flashcard.index',compact('flashcards'));
}

public function create(){
     $lessons =  $this->lessonModel::with('unit')->get();
    return view('Admin.flashcard.create',compact('lessons'));

}

public function store($request){

    
    DB::transaction(function () use ($request){
    $flashCard =  $this->flashCardModel::create([

         'lesson_id'                    => $request->lesson_id,
         'english_word'                 =>$request->english_word,
         'arabic_word'                  =>$request->arabic_word,
         'pronuciation'                 => $request->pronuciation 
    ]);
    if ($request->hasFile('audio')) {
        $filename = time() . '.' . $request->audio->extension();
        $audios =  $this->uploadImage($request->audio, $filename, 'flashcardaudio');
        $audio= 'images/flashcardaudio/'.$audios;
        $flashCard->audios()->create([
            'audio' => $audio,
            'type' => 'audio',
        ]);
    }
  
});
    Alert::success('success', ' FlashCard Added Successfully');
    return redirect()->route('admin.flashcard.index');
}

public function edit($id){
    $flashcard=$this->flashCardModel::find($id);
    $lessons =  $this->lessonModel::get();
    return view('Admin.flashcard.edit',compact('flashcard','lessons'));

}


public function update($request){
    DB::transaction(function () use ($request){
    
    $flashcard=$this->flashCardModel::find($request->id);
    $flashcard->update([

        'lesson_id'                    => $request->lesson_id,
        'english_word'                 =>$request->english_word,
        'arabic_word'                  =>$request->arabic_word,
        'pronuciation'                 => $request->pronuciation
        
        
          
      ]);
      if ($request->hasFile('audio')) {
        $flashcard->audios()->delete();
        $filename = time() . '.' . $request->audio->extension();
        $audios =  $this->uploadImage($request->audio, $filename, 'flashcardaudio');
        $audio= 'images/flashcardaudio/'.$audios;
        $flashcard->audios()->create([
            'audio' => $audio,
            'type' => 'audio',
        ]);
    }
   
});
    Alert::success('success', ' FlashCard  updated Successfully');
    return redirect()->route('admin.flashcard.index');
}

public function  destroy($id){
    $flashCard=$this->flashCardModel::find($id);

    if($flashCard){
        $flashCard->delete();
        return  1;
    }
    return  0;
}



}