<?php
namespace App\Http\Repositories\Admin;

use App\Models\Faq;
use App\Models\FaqCategory;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\FaqInterface;

class FaqRepository implements FaqInterface{

    protected $faqcategoryModel;

    protected $faqModel;

    public function __construct(Faq $faq ,FaqCategory $faqcategory){
        $this->faqModel = $faq;
        $this->faqcategoryModel =$faqcategory;
    }

    public function index(){
        $faqs =$this->faqModel::with('faqcategory')->get();
        return view('Admin.faq.index',compact('faqs')); 
    }

    public function create(){
        $faqcategories= $this->faqcategoryModel::get();
        return view('Admin.faq.create',compact('faqcategories'));
    }

    public function store($request){
        $faq =$this->faqModel::create([

            'faq_category_id'=>$request->faq_category_id,
            'question'       =>$request->question,
            'answer'         =>$request->answer

        ]);

        Alert::success('success','Faq Added Successfully');
        return redirect()->route('admin.faq.index');
    }

    public function edit($id){
        $faq =$this->faqModel::find($id);
        $faqcategories= $this->faqcategoryModel::get();

        return view('Admin.faq.edit',compact('faqcategories','faq'));

    }

    public function update($request){
        $faq =$this->faqModel::find($request->id);
        $faq->update([
            'faq_category_id'=>$request->faq_category_id,
            'question'       =>$request->question,
            'answer'         =>$request->answer
        ]);
        Alert::success('success' ,'Faq updated Successfully');
        return redirect()->route('admin.faq.index');
    }

    public function destroy($id){

        $faq =$this->faqModel::find($id);

        if($faq){
            $faq->delete();

            return 1;
        }
        return 0;

    }
    
}