<?php

namespace App\Http\Repositories\Admin;

use App\Models\DownloadAttachement;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\DownloadAttachementInterface;
use App\Http\Traits\ImageTrait;
use App\Models\Download;

class DownloadAttachementRepository implements DownloadAttachementInterface{

    use ImageTrait;

    protected $downloadAttachementModel;
    protected $downloadModel;


    public function __construct(DownloadAttachement $downloadAttachement ,Download $download){
        $this->downloadAttachementModel =$downloadAttachement;
        $this->downloadModel = $download;
    }
    public function index(){
        $downloadattachements=  $this->downloadAttachementModel::get();
        return view('Admin.downloadattachement.index',compact('downloadattachements'));
    }
    public function create(){
        $downloads = $this->downloadModel::get();
        return view('Admin.downloadattachement.create',compact('downloads'));
    }

    public function store($request)
    {
        $request->validate([
            'download_id' => 'required',
            'title' => 'required'
        ]);

        $downloadattachement =  $this->downloadAttachementModel::create([
            'download_id'        =>$request->download_id,
            'title'             =>  $request->title,
        ]);

        Alert::success('success', ' downloadAttachement Added Successfully');
        return redirect()->route('admin.downloadattachement.index');
    }

    public function edit($id)
    {
        $downloadattachement=$this->downloadAttachementModel::find($id);
        $downloads = $this->downloadModel::get();

        return view('Admin.downloadattachement.edit',compact('downloadattachement','downloads'));

    }

    public function update($request)
    {
        $request->validate([
            'download_id' => 'required',
            'title' => 'required'
        ]);

        $downloadAttachement =  $this->downloadAttachementModel::find($request->id);
        $downloadAttachement->update([
            'download_id'        =>$request->download_id,
            'title'              =>  $request->title,
        ]);

        Alert::success('success', ' downloadAttachement  updated Successfully');
        return redirect()->route('admin.downloadattachement.index');
    }

    public function  destroy($id){
        $downloadAttachement=$this->downloadAttachementModel::find($id);

        if($downloadAttachement){
            $downloadAttachement->delete();
            return  1;
        }

       return 0 ;

    }
}
