<?php

namespace App\Http\Repositories\Admin;

use App\Models\Unit;
use App\Models\Course;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\UnitInterface;
use App\Http\Traits\ImageTrait;
use Illuminate\Support\Facades\DB;

class CourseUnitRepository implements UnitInterface
{
    use ImageTrait;
    protected $unitModel;
    protected $courseModel;
    public function __construct(Unit $unit, Course $course)
    {
        $this->unitModel = $unit;
        $this->courseModel = $course;
    }
    public function index($courseId = null)
    {
        $units    = Unit::where('course_id', $courseId)->with('course')->get();
        $course = $this->courseModel::find($courseId);
        return view('Admin.course.unit.index', compact('units', 'courseId', 'course'));
    }

    public function search($request)
    {
        $units = $this->unitModel::where('title', 'like', '%' . $request->title . '%')->get();
        return view('Admin.course.unit.index', compact('units'));
    }

    public function create($courseId = null)
    {

        $units = $this->unitModel::get();
        $course = $this->courseModel::find($courseId);
        return view('Admin.course.unit.create', compact('courseId', 'course', 'units'));
    }

    public function store($request)
    {

        try {
            DB::beginTransaction();
            if ($request->hasFile('icon')) {
                $filename = time() . '.' . $request->icon->extension();
                $icons = $this->uploadImage($request->icon, $filename, 'unit');
                $icon = 'images/unit/' . $icons;
            }

            $maxNumberUnit = $this->unitModel::WhereCourseId($request->course_id)->max('number');

            $unit = $this->unitModel::create([
                'course_id' => $request->course_id,
                'number' => ++$maxNumberUnit,
                'title' => $request->title,
                'icon' => $icon,
            ]);
            DB::commit();

            Alert::success('success', ' Unit Added Successfully');
            return redirect()->route('admin.course.unit.index', $unit->course_id);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()
                ->back()
                ->withErrors([$e]);
        }
    }

    public function edit($id)
    {
        $unit = $this->unitModel::find($id);
       
        return view('Admin.course.unit.edit', compact('unit'));
    }

    public function update($request)
    {
   
        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons = $this->uploadImage($request->icon, $filename, 'unit');
            $icon = 'images/unit/' . $icons;
        }
        $unit = $this->unitModel::find($request->id);
        $unit->update([
            'course_id' => $request->course_id,
            'number' => $request->number,
            'title' => $request->title,
            'icon' => $icon ?? $unit->icon,
        ]);
        Alert::success('success', ' Unit  updated Successfully');
        return redirect()->route('admin.course.unit.index', $unit->course_id);
    }

    public function destroy($request)
    {
        $id = $request['id'];
        $unit = $this->unitModel::find($id);
        if ($unit) {
            $unit->delete();
            return 1;
        }
        return 0;
    }
}
