<?php
namespace App\Http\Repositories\Admin;

use App\Models\Quiz;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\QuizInterface;
use App\Http\Traits\ImageTrait;
use App\Models\QuizAnswer;
use App\Models\QuizQuestion;

class CourseQuizRepository implements QuizInterface
{
    use ImageTrait;
    protected $quizModel;
    protected $lessonModel;
    protected $quizQuestionModel;
    protected $quizAnswerModel;

    public function __construct(Quiz $quiz, QuizQuestion $quizQuestion, QuizAnswer $quizAnswer)
    {
        $this->quizModel = $quiz;
        $this->quizQuestionModel = $quizQuestion;
        $this->quizAnswerModel = $quizAnswer;
    }
    public function index($lessonId=false)
    {
        $quizzes = $this->quizModel::get();

        return view('Admin.quiz.index', compact('quizzes'));
    }

    public function create($id)
    {
    }

    public function store($request)
    {
        $quiz = $this->quizModel::where('lesson_id', $request->lesson_id)->first();
        if (is_null($quiz)) {
            $quiz = $this->quizModel::create([
                'lesson_id' => $request->lesson_id,
            ]);
        }

        return redirect()->route('admin.course.quizquestion.index', $quiz->id);
    }

    public function edit($id)
    {
        $quiz = $this->quizModel::find($id);
        $lessons = $this->lessonModel::get();

        return view('Admin.quiz.edit', compact('quiz', 'lessons'));
    }

    public function update($request)
    {
        $quiz = $this->quizModel::find($request->id);
        $quiz->update([
            'degree' => $request->degree,
            'lesson_id' => $request->lesson_id,
        ]);

        Alert::success('success', ' ٍquiz  updated Successfully');
        return redirect()->route('admin.quiz.index');
    }

    public function destroy($id)
    {
        $quiz = $this->quizModel::find($id);

        if ($quiz) {
            $quiz->delete();
            return 1;
        }
        return 0;
    }
}
