<?php

namespace App\Http\Repositories\Admin;

use App\Models\Unit;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\UnitInterface;
use App\Models\Course;

class CourseLevelRepository implements UnitInterface
{   
    //Edit this class from CourseLevel to CourseUnit
    use ImageTrait;
    protected $unitModel;
    protected $courseModel;
    public function __construct(Unit $unit, Course $course)
    {
        $this->unitModel = $unit;
        $this->courseModel = $course;
    }
    public function index($courseId = false)
    {
        $units = Unit::where('course_id', $courseId)
            ->with('course')
            ->get();
        $course = $this->courseModel::find($courseId);
        return view('Admin.course.unit.index', compact('units', 'courseId', 'course'));
    }

    public function create($courseId = false)
    {
        $courses = $this->courseModel::get();
        $course = $this->courseModel::find($courseId);

        return view('Admin.course.level.create', compact('courses', 'courseId', 'course'));
    }

    public function store($request)
    {
        $maxNumberLevel = $this->unitModel::whereCourseId($request->course_id)->max('number');

        $level = $this->levelModel::create([
            'course_id' => $request->course_id,
            'number' => $maxNumberLevel + 1,
            'type' => $request->type,
            'price' => $request->price,
            'discount' => $request->discount,
        ]);
        Alert::success('success', ' Level Added Successfully');
        return redirect()->route('admin.course.level.index', $level->course_id);
    }

    public function edit($id)
    {
        $level = $this->levelModel::find($id);
        $courses = $this->courseModel::get();
        return view('Admin.course.level.edit', compact('level', 'courses'));
    }

    public function update($request)
    {
        $unit = $this->unitModel::find($request->id);
        $unit->update([
            'course_id' => $request->course_id,
            'number' => $request->number,
            'type' => $request->type,
            'price' => $request->price,
            'discount' => $request->discount,
        ]);
        Alert::success('success', ' Level  updated Successfully');
        return redirect()->route('admin.course.level.index', $unit->course_id);
    }

    public function destroy($request)
    {
        $id = $request['id'];
        $level = $this->unitModel::find($id);
        if ($level) {
            $level->delete();
            return 1;
        }
        return 0;
    }
}
