<?php

namespace App\Http\Repositories\Admin;

use Embed\Embed;
use App\Models\Unit;
use App\Models\Lesson;
use App\Http\Traits\ImageTrait;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\LessonInterface;

class CourseLessonRepository implements LessonInterface
{
    use ImageTrait;
    protected $lessonModel;
    protected $unitModel;
    public function __construct(Lesson $lesson, Unit $unit)
    {
        $this->lessonModel  = $lesson;
        $this->unitModel    = $unit;
    }
    public function index($unitId = false)
    {
        $lessons = $this->lessonModel::where('unit_id', $unitId)
            ->with('unit')
            ->get();
        $getUnit = $this->unitModel::find($unitId);

        return view('Admin.course.lesson.index', compact('lessons', 'unitId', 'getUnit'));
    }

    public function create($unitId = false)
    {
        $units      = $this->unitModel::get();
        $getUnit    = $this->unitModel::find($unitId);

        return view('Admin.course.lesson.create', compact('units', 'getUnit', 'unitId'));
    }

    public function store($request)
    {
        DB::transaction(function () use ($request) {

            $filename = time() . '.' . $request->notes->extension();
            $notes = $this->uploadImage($request->notes, $filename, 'notes');
            $note = 'images/notes/' . $notes;

            //Load any url:
            $embed = new Embed();
            $info = $embed->get($request->link);


            $maxNumberLesson = $this->lessonModel::whereUnitId($request->unit_id)->max('number');
         
            $lesson = $this->lessonModel::create([
                'unit_id' => $request->unit_id,
                'number' => ++$maxNumberLesson,
                'title' => $request->title,
                'description' => $request->description,
                'link' => $info->code->html ?? '',
                'notes' => $note,
            ]);

            if ($request->hasFile('audio')) {
                $filename = time() . '.' . $request->audio->extension();
                $audios = $this->uploadImage($request->audio, $filename, 'lessonaudio');
                $audio = 'images/lessonaudio/' . $audios;
                $lesson->audios()->create([
                    'audio' => $audio,
                    'type' => 'audio',
                ]);
            }
            if ($request->hasFile('video')) {
                $filename = time() . '.' . $request->video->extension();
                $videos = $this->uploadImage($request->video, $filename, 'lessonvideo');
                $video = 'images/lessonvideo/' . $videos;
                $lesson->videos()->create([
                    'video' => $video,
                    'type' => 'video',
                ]);
            }
            if ($request->hasFile('image')) {
                $filename = time() . '.' . $request->image->extension();
                $images = $this->uploadImage($request->image, $filename, 'lessonimage');
                $image = 'images/lessonimage/' . $images;
                $lesson->images()->create([
                    'image' => $image,
                    'type' => 'image',
                ]);
            }
        });
        Alert::success('success', ' Lesson Added Successfully');
        return redirect()->route('admin.course.lesson.index', $request->unit_id);
    }

    public function edit($id)
    {
        $lesson = $this->lessonModel::find($id);
        $units = $this->unitModel::get();

        return view('Admin.course.lesson.edit', compact('lesson', 'units'));
    }

    public function update($request)
    {
        DB::transaction(function () use ($request) {
            if ($request->hasFile('notes')) {
                $filename = time() . '.' . $request->notes->extension();
                $notes = $this->uploadImage($request->notes, $filename, 'notes');
                $note = 'images/notes/' . $notes;
            }
            if ($request->link) {
                $embed = new Embed();

                //Load any url:
                $info = $embed->get($request->link);
            }

            $lesson = $this->lessonModel::find($request->id);
            $lesson->update([
                'unit_id' => $request->unit_id,
                'number' => $request->number,
                'title' => $request->title,
                'description' => $request->description,
                'link' => $info->code->html ?? '',
                'notes' => $note ?? $lesson->notes,
            ]);

            if ($request->hasFile('audio')) {
                $lesson->audios()->delete();
                $filename = time() . '.' . $request->audio->extension();
                $audios = $this->uploadImage($request->audio, $filename, 'lessonaudio');
                $audio = 'images/lessonaudio/' . $audios;
                $lesson->audios()->create([
                    'audio' => $audio,
                    'type' => 'audio',
                ]);
            }
            if ($request->hasFile('video')) {
                $lesson->videos()->delete();
                $filename = time() . '.' . $request->video->extension();
                $videos = $this->uploadImage($request->video, $filename, 'lessonvideo');
                $video = 'images/lessonvideo/' . $videos;
                $lesson->videos()->create([
                    'video' => $video,
                    'type' => 'video',
                ]);
            }
        });
        Alert::success('success', ' Lesson  updated Successfully');
        return redirect()->route('admin.course.lesson.index', $request->unit_id);
    }

    public function destroy($request)
    {
        $id = $request['id'];
        $lesson = $this->lessonModel::find($id);

        if ($lesson) {
            $lesson->delete();
            return 1;
        }
        return 0;
    }
}
