<?php

namespace App\Http\Repositories\Admin;

use App\Models\Course;
use App\Models\CourseFeature;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\CourseFeatureInterface;

class CourseFeatureRepository implements CourseFeatureInterface{

    protected $coursefeatureModel;
    protected $courseModel;
   

    public function __construct(CourseFeature $coursefeature ,Course $course){

        $this->coursefeatureModel=$coursefeature;
        $this->courseModel=$course;
        
    }

    public function index(){
        $coursefeatures = $this->coursefeatureModel::with('course')->get();
        return view('Admin.coursefeature.index',compact('coursefeatures')); 
    }

    public function create(){
        $courses =$this->courseModel::get();
        return view('Admin.coursefeature.create',compact('courses')); 

    }

    public function store($request){

        $coursefeature =$this->coursefeatureModel::create([

            'feature' => $request->feature,
            'course_id' =>$request->course_id

        ]);
        Alert::success('success', ' CourseFeature Added Successfully');
        return redirect()->route('admin.coursefeature.index');

    }

    public function edit($id){
        $coursefeature =$this->coursefeatureModel::find($id);
        $courses =$this->courseModel::get();
        return view('Admin.coursefeature.edit',compact('coursefeature','courses')); 

        
    }

    public function update($request){

        $coursefeature =$this->coursefeatureModel::find($request->id);

        $coursefeature->update([

            'feature' => $request->feature,
            'course_id' =>$request->course_id

        ]);

        Alert::success('success', ' CourseFeature updated Successfully');
        return redirect()->route('admin.coursefeature.index');



    }

    public function destroy($id){
        $coursefeature =$this->coursefeatureModel::find($id);

        if($coursefeature){
            $coursefeature->delete();
            return  1;
        }
        return  0;
    }
    
}