<?php

namespace App\Http\Repositories\Admin;

use App\Models\CandlyLevel;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\CandlyLevelInterface;

class CandlyLevelRepository  implements CandlyLevelInterface{

    protected $candlyLevelModel;
    public function __construct(CandlyLevel $candlyLevel)
    {
     
        $this->candlyLevelModel=$candlyLevel;
    }
    public function index(){
        $candlylevels=  $this->candlyLevelModel::get();
        return view('Admin.candlylevel.index',compact('candlylevels'));
    }
    
    public function create(){
        return view('Admin.candlylevel.create');
    
    }
    
    public function store($request){
        $request->validate([
            'level' => 'required',
            'xp_points'=>'required'
         ]);
        $candlyLevel =  $this->candlyLevelModel::create([
    
            'level'                     => $request->level,
            'xp_points'                 =>$request->xp_points
            
        ]);
        Alert::success('success', ' candlyLevelAdded Successfully');
        return redirect()->route('admin.candlylevel.index');
    }
    
    public function edit($id){
        $candlylevel=$this->candlyLevelModel::find($id);
        return view('Admin.candlylevel.edit',compact('candlylevel'));
    
    }
    
    
    public function update($request){
        $request->validate([
            'level' => 'required',
            'xp_points'=>'required'
         ]);
        $candlyLevel=$this->candlyLevelModel::find($request->id);
        $candlyLevel->update([
    
            'level'                     => $request->level,
            'xp_points'                 =>$request->xp_points
          
              
          ]);
        Alert::success('success', ' candlyLevel  updated Successfully');
        return redirect()->route('admin.candlylevel.index');
    }
    
    public function  destroy($id){
        $candlyLevel=$this->candlyLevelModel::find($id);
    
        if($candlyLevel){
            $candlyLevel->delete();
        }
        return  1;
    }
}