<?php
namespace App\Http\Repositories\Admin;

use App\Models\Blog;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\BlogInterface;


class BlogRepository implements BlogInterface{
    use ImageTrait;
    protected $blogModel;

    public function __construct(Blog $blog){
        $this->blogModel =$blog;
    }

    public function index(){

        $blogs= $this->blogModel::get();
        return view('Admin.blog.index',compact('blogs'));
    }

    public function create(){
        return view('Admin.blog.create');
    }

    public function store($request){

        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'blog');
            $image= 'images/blog/'.$images;
     
        }

        $blog = $this->blogModel::create([

            'title'      =>$request->title,
            'sub_title'  =>$request->sub_title,
            'description'=>$request->description,
            'image'      =>$image,
            'by'         =>$request->by

        ]);
        Alert::success('success', ' Blog Added Successfully');
        return redirect()->route('admin.blog.index');

    }

    public function edit($id){

        $blog =$this->blogModel::find($id);
        return view('Admin.blog.edit',compact('blog'));
    }

    public function update($request){
        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'blog');
            $image= 'images/blog/'.$images;
     
        }
       
        $blog=$this->blogModel::find($request->id);
        $blog->update([
    
        'title'      =>$request->title,
        'sub_title'  =>$request->sub_title,
        'description'=>$request->description,
        'image'      => $image  ?? $blog->image,
        'by'         =>$request->by

        ]);
        Alert::success('success', ' Blog updated Successfully');
        return redirect()->route('admin.blog.index');
    }

    public function destroy($id){

        $blog =$this->blogModel::find($id);

        if($blog){
            $blog->delete();
            return  1;
        }
        return  0;

    }


    
}