<?php

namespace App\Http\Repositories\Admin;

use App\Models\Role;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\AdminInterface;

class AdminRepository implements AdminInterface
{

    protected $adminModel;
    protected $unitModel;
    public function __construct(Admin $admin)
    {
        $this->adminModel = $admin;
    }
    public function index()
    {
        // $admins     =  $this->adminModel::get();
        $request    = \request();
        $admins     =  $this->allSearch($request);

        return view('Admin.admin.index', compact('admins'));
    }

    public function allSearch($request)
    {
        // dd($request->all());
        $query = $this->adminModel::query();
        if ($request->has('title')) {
            $query->where('name', 'LIKE', "%{$request->title}%");
        }
        $admins =  $query->get();
        return $admins;
    }

    public function create()
    {

        return view('Admin.admin.create');
    }

    public function store($request)
    {


        $admin =  $this->adminModel::create([

            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password)

        ]);


        Alert::success('success', ' ٍadmin Added Successfully');
        return redirect()->route('admin.admin.index');
    }

    public function edit($id)
    {
        $admin = $this->adminModel::find($id);

        return view('Admin.admin.edit', compact('admin'));
    }


    public function update($request)
    {

        $admin = $this->adminModel::find($request->id);
        $admin->update([

            'name' => $request->name,
            'email' => $request->email,
            'password' => isset($request->password) ? Hash::make($request->password) : $admin->password,

        ]);


        Alert::success('success', ' ٍadmin  updated Successfully');
        return redirect()->route('admin.admin.index');
    }

    public function  destroy($id)
    {
        $admin = $this->adminModel::find($id);

        if ($admin) {
            $admin->delete();
            return  1;
        }
        return  0;
    }



    public function changerolePage($id)
    {
        $roles = Role::get();
        $admin = Admin::find($id);
        return view('Admin.admin.changerole', compact('admin', 'roles'));
    }
    public function changerole($request, $id)
    {
        $admin = Admin::find($id);
        $request->validate([
            'roles' => 'required|array|min:1',
            'roles.*' => 'required|exists:roles,id',

        ]);

        $admin->syncRoles($request->roles);

        Alert::success('success', ' ٍadmin  updated Successfully');
        return redirect()->route('admin.admin.index');
    }
}
