<?php

namespace App\Http\Livewire;

use Livewire\Component;
use RealRashid\SweetAlert\Facades\Alert;

class Practice extends Component
{
    protected $listeners = ['goback'];

    public
        $flashcards,
        $data,
        $counter = 0,
        $flashcardcount = 0,
        $showDiv = false,
        $showAudio = false,
        $progress = 0,
        $add = 0;


    public function mount($flashcards)
    {
        $this->flashcards = $flashcards;
    }
    public function render()
    {
        $this->data = $this->flashcards;
        $this->flashcardcount = $this->data->count();
        $this->add = 100 / $this->flashcardcount;

        $this->progress = $this->add * ($this->counter + 1);

        return view('livewire.practice', [$this->data]);
    }
    public function openDiv()
    {
        $this->showDiv = !$this->showDiv;
    }

    public function next()
    {
        $this->progress = $this->add * ($this->counter + 1);
        $this->showDiv = false;
        if ($this->counter < $this->flashcardcount - 1) {

            $this->counter++;
        } else {
            $this->showAudio = !$this->showAudio;
        }
    }

    public function prev()
    {
        $this->counter--;
    }

    public function back($id)
    {

        $this->dispatchBrowserEvent('swal:confirm', [
            'type' => 'warning',
            'title' => 'Are you sure you are ready to leave? Your practice progress will be lost.',
            'text'  => '',
            'id' => $id
        ]);
    }

    public function goback($id)
    {

        return redirect()->route('front.dashboard.lessonFlash', $id);
    }
}
