<?php

namespace App\Http\Livewire;

use App\Models\Test;
use Livewire\Component;
use App\Models\TestAnswer;
use App\Models\StudentTest;
use App\Models\TestQuestion;
use App\Models\StudentTestQuestion;
use App\Models\Setting;
use RealRashid\SweetAlert\Facades\Alert;

class PlacementTest extends Component
{
    public $data,
    $counter=0,
    $questioncount=0,
    $progress= 0,
    $add=0;


    public function render()
    {
        $setting = Setting::first();

        $this->data= TestQuestion::where('status', 1)->with('answers')->inRandomOrder()->limit($setting->test_count)->distinct()->get();

        $this->questioncount= $this->data->count();
        $this->add= 100/$this->questioncount;

        $this->progress= $this->add * ($this->counter +1)  ;

        return view('livewire.placement-test',[$this->data]);
    }

    public function nextQuestion($questionid,$answer,$answerid)
    {
        $getStudent = StudentTest::where('user_id', auth()->user()->id)->first();
        if (!empty($getStudent)) {
            return redirect()->route('front.index');
        }

        $this->progress = $this->add * ($this->counter +1)  ;
        $rightanswer = TestAnswer::where(['question_id' => $questionid, 'is_correct' => 1])->first();
        if (empty($rightanswer)) {
            return $rightanswer;
        }

        StudentTestQuestion::create([
            'user_id' =>auth()->user()->id,
            'question_id' => $questionid,
            'answer_id' => $answerid,
            'answer'    => $answer,
            'degree'     => ($rightanswer->id == $answerid) ? 1 : 0,
        ]);

        if ($this->counter < $this->questioncount - 1) {
            $this->counter++;
        } else {
            $studentdegree= StudentTestQuestion::where('user_id',auth()->user()->id)->sum('degree');

            $test= Test::where('degree', $studentdegree)->first();

            $studenttest = StudentTest::create([
                'total_degree' => $studentdegree,
                'user_id'  => auth()->user()->id,
                'test_id'  => $test->id ?? Test::first()->id
            ]);

            return redirect()->route('auth.testresult', $studenttest);
        }
    }
}
