<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\QuizAnswer;
use App\Models\QuizQuestion;
use App\Models\UserMasteryQuiz;

class MasteryQuiz extends Component
{
    protected $listeners = ['goback'];

    public array $answered = [];
    public $quiz;
    public $studentquiz_id;
    public $data;
    public $counter = 0;
    public $questioncount = 0;
    public $plusprogress;
    public $questions = [];
    public $progress = 0;
    public $add = 0;
    public $anss = [];
    public $matchingcount = 0;
    public $result = 0;
    public $showColor = false;
    public $answerColor = false;
    public $answer_id;
    public $questionid;
    public $rightanswer;
    public $wronganswer = false;
    public $matchans = "";
    public $matchques = "";
    public $checkContainer = false;
    public $checkerAnswerId;
    public $checkerAnswerAnswer;
    public $closeNextAnswer = false;
    public $checkerCounterId;
    public $color = [];

    public function mount($questions)
    {
        $this->quiz = $questions;
    }

    public function render()
    {
        $this->data = $this->quiz;
        $this->questioncount = $this->data->count();
        $this->add = 100 / $this->questioncount;

        $this->progress = $this->add * ($this->counter + 1);

        return view('livewire.mastery-quiz', [$this->data]);
    }

    public function chooseAnswer(
        $questionid,
        $answer,
        $answerid
    ) {
        $this->showColor = true;
        $this->answer_id = $answerid;

        if (in_array($questionid, $this->answered)) {
            unset($this->answer_id);
            return;
        }

        $this->answered[] = $questionid;

        $rightanswer = QuizAnswer::where([['question_id', '=', $questionid], ['is_correct', '=', 1]])->first();

        $this->rightanswer = $rightanswer->id;

        if ($rightanswer->id ==   $answerid) {
            $this->answerColor = true;
        } else {
            $this->wronganswer = true;
        }

        if (!($rightanswer->question->type == 'matchingpairs')) {
            UserMasteryQuiz::create([
                'user_id' => auth()->user()->id,
                'question_id' => $questionid,
                'due' => (($rightanswer->id == $answerid) ? 1 : 0),
                'status'    => (($rightanswer->id == $answerid) ? 1 : 0),
            ]);
        }
        unset($this->answer_id);
        $this->checkContainer = false;
    }

    public function nextQuestion()
    {
        $this->showColor = false;
        $this->wronganswer = false;
        $this->answerColor = false;
        $this->progress = $this->add * ($this->counter + 1);

        if ($this->counter < $this->questioncount - 1) {
            $this->counter++;
        } else {
            return redirect()->route('front.dashboard.masteryquizresult');
        }
    }

    public function matchingPairs($question_id, $question)
    {
        $this->matchques = $question;
        $quetions = QuizQuestion::with('answer')->find($question_id);

        $ques = explode(',', $quetions->question);
        $this->matchingcount++;

        foreach ($ques as $key => $q) {
            if ($q  == $question) {
                $this->color[] = mt_rand(0, 0xFFFFFF);
                $this->questions = $key;
            }
        }
    }

    public function answer($question_id, $answer, $answer_id)
    {

        $this->matchans = $answer;
        $quizanswer = QuizAnswer::with('question')->find($answer_id);
        $qanswer = QuizAnswer::where('question_id', $question_id)->get();

        if ($quizanswer->status == $this->questions) {
            $this->anss[]++;
        }

        if ($this->matchingcount == count($qanswer)) {

            $this->showColor = true;
            $userques = UserMasteryQuiz::where([['user_id', auth()->user()->id], ['question_id', $question_id]])->first();

            if ($userques) {
                $userques->update([
                    'due' => $userques->due + (array_sum($this->anss) == count($qanswer)  ? 1 : 0),
                    'status'    => (array_sum($this->anss) == count($qanswer)  ? 1 : 0),
                ]);
            } else {
                UserMasteryQuiz::create([
                    'user_id' => auth()->user()->id,
                    'question_id' => $question_id,
                    'due' => (array_sum($this->anss) == count($qanswer)  ? 1 : 0),
                    'status'    => (array_sum($this->anss) == count($qanswer)  ? 1 : 0),
                ]);
            }

            if (array_sum($this->anss) == count($qanswer)) {
                $this->answerColor = true;
            } else {
                $this->wronganswer = true;
            }

            $this->anss = [];
            $this->matchingcount = 0;
        }

        unset($this->answer_id);
    }

    public function back($id)
    {
        $this->dispatchBrowserEvent('swal:confirm', [
            'type' => 'warning',
            'title' => 'Are you sure you are ready to leave? ',
            'text'  => '',
            'id' => $id
        ]);
    }

    public function goback($id) {
        return redirect()->route('front.dashboard.lessonFlash', $id);
    }

    public function setAnswer(
        $checkerCounterId,
        $checkerAnswerAnswer,
        $checkerAnswerId,
    ) {
        $this->checkerAnswerId = $checkerAnswerId;
        $this->checkerAnswerAnswer = $checkerAnswerAnswer;
        $this->checkerCounterId = $checkerCounterId;

        $this->checkContainer = true;
    }
}
