<?php

namespace App\Http\Livewire;

use Carbon\Carbon;
use Livewire\Component;
use App\Models\CandlyLevel;
use App\Models\StudentCandlyLevel;
use App\Models\UserMasterFlashCard;

class MasteryFlashCard extends Component
{

    protected $listeners = ['goback'];

    public
        $flashcards,
        $data,
        $counter = 0,
        $flashcardcount = 0,
        $showDiv = false,
        $progress = 0,
        $add = 0;


    public function mount($flashcards)
    {


        $this->flashcards = $flashcards;
    }
    public function render()
    {




        $this->data = $this->flashcards;

        $this->flashcardcount = $this->data->count();
        $this->add = 100 / $this->flashcardcount;

        $this->progress = $this->add * ($this->counter + 1);

        return view('livewire.mastery-flash-card', [$this->data]);
    }



    public function openDiv()
    {
        $this->showDiv = !$this->showDiv;
    }


    public function next($flash_id, $due)
    {
        $userflash = UserMasterFlashCard::where([['flash_card_id', $flash_id], ['user_id', auth()->user()->id]])->first();

        $this->progress = $this->add * ($this->counter + 1);
        $this->showDiv = false;



        if ($userflash) {

            $userflash->update([
                'due'  => $userflash->due  + $due,
                'status' => $due
            ]);
        } else {
            $userflash = UserMasterFlashCard::create([
                'user_id' => auth()->user()->id,
                'flash_card_id' => $flash_id,
                'due'  => $due,
                'status' => $due
            ]);
        }


        if ($this->counter < $this->flashcardcount - 1) {

            $this->counter++;
        } else {

            if ($this->counter == 25) {
                $user = auth()->user();
                $date = Carbon::parse($user->streak_updated);

                if (($date->diffInDays(Carbon::now())) !== 0) {
                    $user->update([
                        'streak' => ($user->streak + 1),
                        'streak_updated' => date("Y-m-d H:i:s"),
                    ]);
                };

                $studentlevel = StudentCandlyLevel::where('user_id', auth()->user()->id)->latest();
                $candlylevel = CandlyLevel::where('id', '>', $studentlevel->candly_level_id)->orderBy('id')->first();
                if ($studentlevel->xp_points == $studentlevel->candlylevel->xp_points) {
                    $studentlevel = StudentCandlyLevel::create([
                        'user_id' => $user->id,
                        'candly_level_id' => $candlylevel->id,
                        'xp_points' =>  2

                    ]);
                    $studentlevel->update([
                        'status' => 1
                    ]);
                } else {
                    $studentlevel->update([
                        'xp_points' => $studentlevel->xp_points + 2
                    ]);
                }
            }
            return redirect()->route('front.dashboard.masteryflashcardresult', $userflash->id);
        }
    }


    public function back($id)
    {

        $this->dispatchBrowserEvent('swal:confirm', [
            'type' => 'warning',
            'title' => 'Are you sure you are ready to leave? ',
            'text'  => '',
            'id' => $id
        ]);
    }

    public function goback($id)
    {

        return redirect()->back();
    }
}
