<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Service\UserOtpService;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Front\FrontInterface;
use Illuminate\Validation\ValidationException;
use App\Http\Requests\Front\Contact\CreateContactRequest;

class FrontController extends Controller
{
    protected $frontInterface;

    public function __construct(FrontInterface $frontInterface)
    {
        $this->frontInterface = $frontInterface;
    }

    public function index()
    {
        
        return $this->frontInterface->index();
    }

    public function subpage($slug)
    {
        return $this->frontInterface->subpage($slug);
    }


    public function about()
    {
        return $this->frontInterface->about();
    }

    public function contact()
    {
        return $this->frontInterface->contact();
    }

    public function  howToRegister()
    {
        return $this->frontInterface->howToRegister();
    }

    public function  video()
    {
        return $this->frontInterface->video();
    }

    public function  policy()
    {
        return $this->frontInterface->policy();
    }

    public function  terms()
    {
        return $this->frontInterface->terms();
    }

    public function contactstore(CreateContactRequest $request)
    {
        return $this->frontInterface->contactstore($request);
    }

    public function verifyPage()
    {
        // dd(auth()->user());
        if (is_null(auth()->user()->otp_code)) {
            (new UserOtpService)->sendCode();
        }
        return view('Front.Auth.verify-user-otp')->with('success', ['You have received a new code, checkout your email address.']);
    }

    public function verifyAccount(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|size:7',
        ]);

        if (auth()->user()->otp_code !== $request->code) {
            throw ValidationException::withMessages(['code' => ['Code does not match.']]);
        }

        auth()->user()->update([
            'otp_code' => null,
            'email_verified_at' => now(),
            'is_active' => 1,
        ]);

        return redirect()->route('front.dashboard.index', 1);
    }
}
