<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Front\DashboardInterface;
use App\Http\Requests\Admin\LessonFaqs\CreateLessonFaqRequest;
use App\Http\Requests\Admin\LessonReviews\CreateLessonReviewRequest;

class DashboardController extends Controller
{


    protected $dashboardInterface;

    public function __construct(DashboardInterface $dashboardInterface)
    {
        $this->dashboardInterface =$dashboardInterface;
    }

    public function index($id){
        return $this->dashboardInterface->index($id);
    }

    public function unitLesson($id){
        return $this->dashboardInterface->unitLesson($id);
    }
    public function blog(){
        return $this->dashboardInterface->blog();
    }

    public function singleBlog($id){
        return $this->dashboardInterface->singleBlog($id);
    }
    public function dashboardSign(){
        return $this->dashboardInterface->dashboardSign();
    }

    public function dashboardPlacement(){
        return $this->dashboardInterface->dashboardPlacement();
    }

    public function lessonFlash($id){
        return $this->dashboardInterface->lessonFlash($id);
    }

    public function lessonPractice($id){
        return $this->dashboardInterface->lessonPractice($id);

    }
    public  function lessonFaq(CreateLessonFaqRequest $request){
        return $this->dashboardInterface->lessonFaq($request);
    }
    public  function lessonReview(Request $request){
        return $this->dashboardInterface->lessonReview($request);
    }
    public function lessonRate($rate,$lesson_id){
        return $this->dashboardInterface->lessonRate($rate,$lesson_id);
    }


    public function price(){
        return $this->dashboardInterface->price();
    }

    public function  startCourseBeginner(){
        return $this->dashboardInterface->startCourseBeginner();
    }


    public function  startCourseTestResult($id){
        return $this->dashboardInterface->startCourseTestResult($id);
    }

    public function guides(){
        return $this->dashboardInterface->guides();
    }

    public function guidesDetails($id){
        return $this->dashboardInterface->guidesDetails($id)    ;
    }

    public function guidesSetting(){
        return $this->dashboardInterface->guidesSetting()    ;
    }

    public function guidesAccount($id){
        return $this->dashboardInterface->guidesAccount($id)     ;
    }

    public function contact(){
        return $this->dashboardInterface->contact()    ;
    }

    public function messages( Request $request){
        return $this->dashboardInterface->messages($request);

    }

    public function notifications(){
        return $this->dashboardInterface->notifications();
    }


   public function markRead($id){
    return $this->dashboardInterface->markRead($id);

   }

   public function markAllRead(){
    return $this->dashboardInterface->markAllRead();
   }


   public function next($id){
    return $this->dashboardInterface->next($id);
   }
   public function previous($id){
    return $this->dashboardInterface->previous($id);

   }

}
