<?php

namespace App\Http\Controllers\Front;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Front\AuthInterface;
use App\Http\Requests\Auth\LoginRequest;
use App\Http\Requests\Auth\RegisterRequest;
use App\Service\TapPaymentService\TapService;
use App\Service\UserOtpService;

class AuthController extends Controller
{
    protected $authInterface;


    public function __construct(AuthInterface $authInterface)
    {
        $this->authInterface = $authInterface;
    }

    public function registerPage()
    {
        return  $this->authInterface->registerPage();
    }

    public function register(RegisterRequest $request)
    {
        return  $this->authInterface->register($request);
    }


    public function loginPage()
    {
        return  $this->authInterface->loginPage();
    }

    public function login(LoginRequest $request)
    {
        return  $this->authInterface->login($request);
    }

    public function logout()
    {
        return  $this->authInterface->logout();
    }

    public function getName()
    {
        return $this->authInterface->getName();
    }
    public function storeName(Request $request)
    {
        return $this->authInterface->storeName($request);
    }

    public function getCountry()
    {
        return $this->authInterface->getCountry();
    }

    public function storeCountry(Request $request)
    {
        return $this->authInterface->storeCountry($request);
    }

    public function emailVerificationPage()
    {

        return $this->authInterface->emailVerificationPage();
    }

    public function emailVerificationStore(Request $request)
    {
        return $this->authInterface->emailVerificationStore($request);
    }

    // public function sendNotification(){
    //     return $this->authInterface->sendNotification();
    // }

    // public function acceptNotification(Request $request){
    //     return $this->authInterface->acceptNotification($request);
    // }


    public function uploadImg()
    {
        return $this->authInterface->uploadImg();
    }
    public function storeImg(Request $request)
    {
        return $this->authInterface->storeImg($request);
    }

    public function levelQuiz()
    {
        return $this->authInterface->levelQuiz();
    }


    // public function testTapPayment(TapService $tapService)
    // {
    //     $response = $tapService->customerDetails(
    //         first_name: "test",
    //         last_name: "test",
    //         email: "test@mail.com",
    //         phone_code: 965,
    //         phone_number: 51234567,
    //     )
    //         ->amount(100)
    //         ->currency()
    //         ->redirect(route('tap-redirect'))
    //         ->charge();

    //     return redirect()->to($response->transaction->url);
    // }

    // public function tapRedirect(Request $request, TapService $tapService)
    // {
    //     $invoice = $tapService->getCharge($request->tap_id);

    //     dd($invoice);
    // }
}
