<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\SubPageInterface;
use App\Http\Requests\Admin\Page\CreatePageRequest;
use App\Http\Requests\Admin\Page\UpdatePageRequest;

class SubPageController extends Controller
{
  protected $subPageInterface;

  public function __construct(SubPageInterface $subPageInterface)
   {
      $this->subPageInterface =$subPageInterface;

   }

  public function index()
  {
    return $this->subPageInterface->index();
   }

  public function create(){
    return $this->subPageInterface->create();
  }

  public function store(CreatePageRequest $request){
    return $this->subPageInterface->store($request);

  }

  public function edit($id){
    return $this->subPageInterface->edit($id);
  }

  public function update(UpdatePageRequest $request){
    return $this->subPageInterface->update($request);
  }

  public function destroy($id){
    return $this->subPageInterface->destroy($id);
  }

}
