<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\SettingInterface;
use App\Http\Requests\Admin\Setting\UpdateSettingRequest;

class SettingController extends Controller
{
    protected $settingInterface;

    public function __construct(SettingInterface $settingInterface)
    {
        $this->settingInterface = $settingInterface;
    }

    public function update(UpdateSettingRequest $request)
    {
        return $this->settingInterface->update($request);
    }

    public function edit()
    {
        return $this->settingInterface->edit();
    }
}
