<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\QuizInterface;
use App\Http\Requests\Admin\Quiz\CreateQuizRequest;
use App\Http\Requests\Admin\Quiz\UpdateQuizRequest;

class QuizController extends Controller
{
    protected $quizInterface;

    public function __construct(QuizInterface $quizInterface)
    {
        $this->quizInterface=$quizInterface;
    }
    public function index(){
       return  $this->quizInterface->index();
    }
    
    public function create($id){
        return  $this->quizInterface->create($id);
    }

    public function store( CreateQuizRequest $request){
        return  $this->quizInterface->store($request);
    }

    public function edit($id){
        return  $this->quizInterface->edit($id);
    }

    public function update( UpdateQuizRequest $request){
        return  $this->quizInterface->update($request);
    }


    public function destroy($id){
        return  $this->quizInterface->destroy($id);
    }
}
