<?php

namespace App\Http\Controllers\Admin;

use App\Models\Course;
use App\Models\Package;
use App\Http\Controllers\Controller;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\PackageInterface;
use App\Http\Requests\Admin\Package\PackageRequest;

class PackageController extends Controller
{
    protected $packageRepository;

    public function __construct(PackageInterface $packageRepository)
    {
        $this->packageRepository = $packageRepository;
    }

    public function index()
    {
        $packages = $this->packageRepository->index();
        return view('Admin.package.index', compact('packages'));
    }

    public function create()
    {
        $courses = Course::get(['id', 'title']);
        return view('Admin.package.create', compact('courses'));
    }

    public function store(PackageRequest $request)
    {
        $this->packageRepository->store($request->validated());
        Alert::success('success', 'Package created successfully');
        return back();
    }

    public function edit(Package $package)
    {
        $package->load(['courses']);
        $courses = Course::get(['id', 'title']);
        return view('Admin.package.edit', compact('package', 'courses'));
    }

    public function update(PackageRequest $request, Package $package)
    {
        $this->packageRepository->update($package, $request->validated());
        Alert::success('success', 'Package updated successfully');
        return back();
    }

    public function destroy(Package $package)
    {
        $this->packageRepository->destroy($package);
        Alert::success('success', 'Package deleted successfully');
        return back();
    }
}
