<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\LessonInterface;
use App\Http\Requests\Admin\Lesson\CreateLessonRequest;
use App\Http\Requests\Admin\Lesson\UpdateLessonRequest;

class LessonController extends Controller
{
    protected $lessonInterface;

    public function __construct(LessonInterface $lessonInterface)
    {
        $this->lessonInterface = $lessonInterface;
    }

    public function index()
    {
        return $this->lessonInterface->index();
    }


    public function create()
    {
        return $this->lessonInterface->create();
    }

    public function store(CreateLessonRequest $request)
    {
        return $this->lessonInterface->store($request);
    }

    public function edit($id)
    {
        return $this->lessonInterface->edit($id);
    }

    public function update(UpdateLessonRequest $request)
    {
        return $this->lessonInterface->update($request);
    }

    public function  destroy($id)
    {
        return $this->lessonInterface->destroy($id);
    }
}
