<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\FlashCardInterface;
use App\Http\Requests\Admin\FlashCards\CreateFlashCardRequest;
use App\Http\Requests\Admin\FlashCards\UpdateFlashCardRequest;

class FlashCardController extends Controller
{
    protected $flashCardInterface;

    public function __construct(FlashCardInterface $flashCardInterface)
    {
        $this->flashCardInterface =$flashCardInterface;
    }

    public function index(){
        return $this->flashCardInterface->index();
    }


    public function create(){
         return $this->flashCardInterface->create();
    }

    public function store(CreateFlashCardRequest $request){
         return $this->flashCardInterface->store($request);
    }

    public function edit($id){
         return $this->flashCardInterface->edit($id);
    }

    public function update(UpdateFlashCardRequest $request){
         return $this->flashCardInterface->update($request);
    }
    
    public function  destroy($id){
         return $this->flashCardInterface->destroy($id);
    }
 
}
