<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\FaqInterface;
use App\Http\Requests\Admin\Faq\CreateFaqRequest;
use App\Http\Requests\Admin\Faq\UpdateFaqRequest;

class FaqController extends Controller
{
    protected $faqInterface;

    public function __construct(FaqInterface $faqInterface){
        $this->faqInterface=$faqInterface;
    }

    public function index(){
        return $this->faqInterface->index();
    }

    public function create(){
        return $this->faqInterface->create();
    }

    public function store(CreateFaqRequest $request){

        return $this->faqInterface->store($request);
        
    }

    public function edit($id){
        return $this->faqInterface->edit($id);
    }

    public function update(UpdateFaqRequest $request){
        return $this->faqInterface->update($request);
        
    }

    public function destroy($id){
        return $this->faqInterface->destroy($id);
    }
}
