<?php

namespace App\Http\Controllers\Admin;

use App\Models\Level;
use App\Models\Course;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Repositories\Admin\CourseLevelRepository;
use App\Http\Requests\Admin\Levels\CreateLevelRequest;
use App\Http\Requests\Admin\Levels\UpdateLevelRequest;

class CourseLevelController extends Controller
{
    protected $courseLevelInterface;

    public function __construct(CourseLevelRepository $courseLevelInterface)
    {
        $this->courseLevelInterface = $courseLevelInterface;
    }

    public function index($courseId)
    {
        return $this->courseLevelInterface->index($courseId);
    }

    // public function show($id)
    // {
    //     $levels = Level::where('course_id', $id)
    //         ->with('course')
    //         ->get();
    //     return view('Admin.level.index', compact('levels', 'id'));
    // }

    public function create($courseId)
    {
        return $this->courseLevelInterface->create($courseId);
    }

    public function store(CreateLevelRequest $request)
    {
        return $this->courseLevelInterface->store($request);
    }

    public function edit($id)
    {
        return $this->courseLevelInterface->edit($id);
    }

    public function update(UpdateLevelRequest $request)
    {
        return $this->courseLevelInterface->update($request);
    }

    public function destroy(Request $request)
    {
        return $this->courseLevelInterface->destroy($request);
    }
}
