<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Repositories\Admin\CourseLessonRepository;
use App\Http\Requests\Admin\Lesson\CreateLessonRequest;
use App\Http\Requests\Admin\Lesson\UpdateLessonRequest;

class CourseLessonController extends Controller
{
    protected $courseLessonInterface;

    public function __construct(CourseLessonRepository $courseLessonInterface)
    {
        $this->courseLessonInterface = $courseLessonInterface;
    }

    public function index($unitId)
    {
        return $this->courseLessonInterface->index($unitId);
    }


    public function create($unitId)
    {
        return $this->courseLessonInterface->create($unitId);
    }

    public function store(CreateLessonRequest $request)
    {
        return $this->courseLessonInterface->store($request);
    }

    public function edit($id)
    {
        return $this->courseLessonInterface->edit($id);
    }

    public function update(UpdateLessonRequest $request)
    {
        return $this->courseLessonInterface->update($request);
    }

    public function  destroy(Request $request, $id)
    {
        return $this->courseLessonInterface->destroy($request);
    }
}
