<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\CourseFeatureInterface;
use App\Http\Requests\Admin\CourseFeature\CreateCourseFeature;
use App\Http\Requests\Admin\CourseFeature\UpdateCourseFeature;

class CourseFeatureController extends Controller
{
    protected $coursefeatureInterface;

    public function __construct(CourseFeatureInterface $coursefeatureInterface){
        $this->coursefeatureInterface =$coursefeatureInterface;
    }

    public function index(){
        return $this->coursefeatureInterface->index();
    }

    public function create(){
        return $this->coursefeatureInterface->create();
    }

    public function store(CreateCourseFeature $request){

        return $this->coursefeatureInterface->store($request);
        
    }

    public function edit($id){
        return $this->coursefeatureInterface->edit($id);
    }

    public function update(UpdateCourseFeature $request){

        return $this->coursefeatureInterface->update($request);
        
    }

    public function destroy($id){
        return $this->coursefeatureInterface->destroy($id);
    }
}
