<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\CourseInterface;
use App\Http\Requests\Admin\Courses\CreateCourseRequest;
use App\Http\Requests\Admin\Courses\UpdateCourseRequest;

class CourseController extends Controller
{
    protected $courseInterface;

    public function __construct(CourseInterface $courseInterface)
    {
        $this->courseInterface = $courseInterface;
    }

    public function index()
    {
        return $this->courseInterface->index();
    }

    public function search(Request $request)
    {
        return $this->courseInterface->search($request);
    }


    public function create()
    {
        return $this->courseInterface->create();
    }

    public function store(CreateCourseRequest $request)
    {
        return $this->courseInterface->store($request);
    }

    public function edit($id)
    {
        return $this->courseInterface->edit($id);
    }

    public function update(UpdateCourseRequest $request)
    {
        return $this->courseInterface->update($request);
    }

    public function  destroy($id)
    {
        return $this->courseInterface->destroy($id);
    }
}
