<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\BlogInterface;
use App\Http\Requests\Admin\Blog\CreateBlogRequest;
use App\Http\Requests\Admin\Blog\UpdateBlogRequest;

class BlogController extends Controller
{
    protected $blogInterface;
    public function __construct(BlogInterface $blogInterface){
        $this->blogInterface =$blogInterface;
    }

    public function index(){
        return $this->blogInterface->index();
    }

    public function create(){
        return $this->blogInterface->create();
    }

    public function store(CreateBlogRequest $request){
        return $this->blogInterface->store($request);

    }
    public function edit($id){
        return $this->blogInterface->edit($id);

    }

    public function update(UpdateBlogRequest $request){
        return $this->blogInterface->update($request);
    }

    public function destroy($id){
        return $this->blogInterface->destroy($id);

    }

}
