<?php

namespace App\Imports;

use App\Models\Test;
use Maatwebsite\Excel\Concerns\ToModel;
use Illuminate\Support\Facades\Validator;

class TestImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        Validator::make($row, [
            '1' => 'required',
            '2' => 'required',
        ],[
           '1.required'  => 'This field degrees is required',
           '2.required'  => 'This field levels is required',
        ])->validate();

        return new Test([
            'degree'    => $row[1],
            'level_id'  => $row[2],
        ]);
    }
}
