<?php

namespace App\Imports;

use App\Models\Country;
use Maatwebsite\Excel\Concerns\ToModel;
use Illuminate\Support\Facades\Validator;

class CountryImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        Validator::make($row, [
            '0' => 'required',
        ],[
           '0.required'  => 'This field degrees is required',
        ])->validate();

        return new Country([
            'country' => $row[0],
        ]);
    }
}
